<?php

namespace Fir\Controllers;

class Login extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;
	
    public function index()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
			
		$validation = "";	

        $user = $this->library('User');
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
        
        $adminModel = $this->model('Admin');
        $data['start'] = $adminModel->start_array();
        
        $data['language'] = $this->language;

        // If the user tries to log-in
			if(isset($_POST['login'])) {
		
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'password' => [
				 'required' => true,
				 'minlength' => 2,
				 'maxlength' => 200
			   ]
			]);
				 
			if (!$validation->fails()) {
					$cpr = $_POST['cpr'];
					$password = $_POST['password'];
					$remember = null;
					
				if(strlen((string)$cpr) == $data['settings']['cpr_char_limit']){	
					
					if(isset($_POST['remember'])) {
					  $remember = ($_POST['remember'] === 'on') ? true : false;
					}

					// Attempt to auth the user
					$auth = $user->login(
						 $cpr,
						 $password,
						 $remember
					  );

					// If the user has been logged-in
					if($auth) {
						$_SESSION['user_type'] = $user->data()["user_type"];
						$_SESSION['cpr'] = $cpr;
						$_SESSION['password'] = $password;
						$_SESSION['remember'] = $remember;
						$_SESSION['is_admin'] = 0;
						redirect('otp');
						 // if($user->data()["user_type"] === "1"){
							
						 // }

						 // if($user->data()["user_type"] === "1"){
							// redirect('user/dashboard');
						 // }elseif($user->data()["user_type"] === "2"){
							// redirect(CANDIDATE_URL.'/dashboard');
						 // }
                        
					}
					// If the user could not be logged-in
					elseif(isset($_POST['login'])) {
						$_SESSION['message'][] = ['error', $this->lang['invalid_user_pass']];
					}
				}else{
						$_SESSION['message'][] = ['error', $this->lang['invalid_cpr']];
				}	

				}
			else {
			 foreach ($validation->errors()->all() as $err) {
				$str = implode(" ",$err);
				 foreach ($err as $r) {
					$_SESSION['errors'][] = ['error', $r];
				 }	
			 }
			}
		}	

        return ['content' => $this->view->render($data, 'home/login')];
    }
	

}