<?php

namespace Fir\Controllers;
 
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class User extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;
	
    public function index()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
			
		$validation = "";	
		
		/* Use User Library */
        $user = $this->library('User');
		$data['user'] = $user->data();
		if(!$user->isLoggedIn()):
			redirect('login');
		elseif($data['user']['user_type'] != 1):
			redirect('login');
		endif;
        
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
        
        //Post
        if(isset($_POST['dashboard'])){
         if ($input->exists()) {

            $validator = $this->library('Validator');

            $validation = $validator->check($_POST, [
                  'name' => [
                     'required' => true,
                  ],
                  'email' => [
                     'required' => true,
                     'email' => true,
                  ]
            ]);

            if (!$validation->fails()) {

                $update = $userModel->update($input->get('name'), 
                                                  $input->get('email'), 
                                                  $data['user']['userid']);

                if ($update == 1) {
                    $_SESSION['message'][] = ['success', $this->lang['details_updated']];
                    redirect('user/dashboard');
                } else {
                    $_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
                    redirect('user/dashboard');
                }

             } else {

                 foreach ($validation->errors()->all() as $err) {
                    $str = implode(" ",$err);
                     foreach ($err as $r) {
                        $_SESSION['errors'][] = ['error', $r];
                     }	
                 }

                    redirect('user/dashboard');
           }

         }
        } 

        return ['content' => $this->view->render($data, 'user/dashboard')];
    }
	
    public function logout() {
        $user = $this->library('User');
		
		$user->logout();
		
		redirect('login');
    }
	
    public function image()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use User Library */
        $user = $this->library('User');
		$data['user'] = $user->data();
		if(!$user->isLoggedIn()):
			redirect('login');
		elseif($data['user']['user_type'] != 1):
			redirect('login');
		endif;
		
		/*Use User Model*/
        $userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
		

		/*Edit Image Data*/
		if(isset($_POST['picture'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/users/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['user']['imagelocation'] ?? null;

					// Remove the old variant of the image
					if($data['user']['imagelocation'] != "default.png"):
						if($oldFileName && $oldFileName != $fileName) {
							unlink($path.$oldFileName);
						}
					endif;	
				
					$update = $userModel->changeImage($fileName, $data['user']['userid']);
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('user/image');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('user/image');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('user/image');
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('user/image');	
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('user/image');
			  }	
			
		 }	
		}

        return ['content' => $this->view->render($data, 'user/image')];
    }
	
    public function password()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/*Use User Library*/
        $user = $this->library('User');
		$data['user'] = $user->data();
		if(!$user->isLoggedIn()):
		 redirect('login');
		endif;
		
		/*Use User Model*/
        $userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');

		
		//Edit
		if(isset($_POST['edit_password'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
				  'password_current' => [
					 'required' => true,
				  ],
				   'password' => [
					 'required' => true,
				   ],
				   'confirmPassword' => [
					 'required' => true,
					 'match' => 'password'
				   ]
			]);
				 
			if (!$validation->fails()) {

				if (password_verify($input->get('password_current'), $data['user']['password'])) {
					
					/* Hash Password */
					$password = password_hash($input->get('password'), PASSWORD_DEFAULT);
					
					$update = $userModel->password($password, $data['user']['userid']);
						
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('user/password');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('user/password');
					}
					
				} else {
					
					$_SESSION['message'][] = ['error', $this->lang['current_password_does_not_match']];
						redirect('user/password');
				 
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
						redirect('user/password');
		   }

		 }
		}	

        return ['content' => $this->view->render($data, 'user/password')];
    }
	
	//Random String
	private function rando($length = 14){
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < $length; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		return $str;
	}
}