<?php

namespace Fir\Models;

class User extends Model {
		
    /**
     * Add User
     *
     */
    public function add($userid, $name, $email, $cpr, $mobile, $password) {

		$filename = "default.png";
		
	    $Insert = $this->db->insert('user', array(
	   'userid' => $userid,
	   'password' => $password,
	   'name' => $name,
	   'email' => $email,
	   'cpr' => $cpr,
	   'mobile' => $mobile,
	   'imagelocation' => $filename,
	   'joined' => date('Y-m-d H:i:s'),
	   'user_type' => 1
		));	
		  
		return $Insert->rowCount();  
    }
    public function details()
    {
		
        $query = $this->db->select('user', '*', ["ORDER" =>["joined" => "DESC"]]);

        return $query;
    }
    public function has($id) {

		$has = $this->db->has("user", ["userid" => $id]);		
		  
		return $has;  
    }
    public function hasEmail($email) {

		$has = $this->db->has("user", ["email" => $email]);		
		  
		return $has;  
    }
    public function hasCpr($cpr) {

		$has = $this->db->has("user", ["cpr" => $cpr]);		
		  
		return $has;  
    }
    public function hasToken($token) {

		$has = $this->db->has("user", ["tokencode" => $token]);		
		  
		return $has;  
    }
    public function hasRegisterToken($token) {

		$has = $this->db->has("user", ["registercode" => $token]);		
		  
		return $has;  
    }
    public function get($id) {

		$query = $this->db->select("user", "*", ["userid" => $id]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function getId($id) {

		$query = $this->db->select("user", "*", ["id" => $id]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function getEmail($email) {

		$query = $this->db->select("user", "*", ["email" => $email]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function getCpr($cpr) {

		$query = $this->db->select("user", "*", ["cpr" => $cpr]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function getwithToken($token) {

		$query = $this->db->select("user", "*", ["tokencode" => $token]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function getwithRegisterToken($token) {

		$query = $this->db->select("user", "*", ["registercode" => $token]);	
        foreach($query as $row){}		
		  
		return $row;  
    }
    public function update($name, $email, $id) {

		$Update = $this->db->update('user',[
		   'name' => $name,
		   'email' => $email,
		],[
		    'userid' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
    public function updateVoter($name, $email, $cpr, $mobile, $id) {

		$Update = $this->db->update('user',[
		   'name' => $name,
		   'email' => $email,
		   'cpr' => $cpr,
		   'mobile' => $mobile,
		],[
		    'id' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
    public function token($id, $token) {

		$Update = $this->db->update('user',[
		   'tokencode' => $token,
		],[
		   'userid' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
    public function verifyEmail($no, $token, $id) {

		$Update = $this->db->update('user',[
		   'verified' => $no,
		   'registercode' => $token,
		],[
		   'userid' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
    public function updateVerify($id) {

		$Update = $this->db->update('user',[
		   'verified' => '1',
		   'registercode' => '',
		],[
		   'userid' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update password
     *
     */
    public function updatePassword($password, $id) {

		$Update = $this->db->update('user',[
		   'password' => $password,
		   'tokencode' => '',
		],[
		   'userid' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
    
    public function updateVoterPassword($password, $id) {

		$Update = $this->db->update('user',[
		   'password' => $password,
		   'tokencode' => '',
		],[
		   'id' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Image
     *
     */
    public function changeImage($filename, $id) {

		$Update = $this->db->update('user',[
		   'imagelocation' => $filename
		],[
		    'userid' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update password
     *
     */
    public function password($password, $id) {

		$Update = $this->db->update('user',[
		   'password' => $password,
		],[
		    'userid' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Count Users
     *
     */
    public function cusers() {

		$query = $this->db->count("user", []);			
		  
		return $query;    
    }
	
    /**
     * Count Users
     *
     */
    public function vusers() {

		$query = $this->db->count("user", ["verified" => 1]);			
		  
		return $query;    
    }
	
    /**
     * Unapproved Voters
     *
     */
    public function list()
    {
            $query = $this->db->select("user", '*', [
                "OR" => [
                    "AND #first" => [
                        "user_type" => "1",
                        "approved" => "0"
                    ],
                    "AND #second" => [
                        "user_type" => "1",
                        "approved" => "2"
                    ]
                ],
                "ORDER" =>["joined" => "DESC"]
            ]);
        
       //$query = $this->db->select('user', '*', ["AND" => ["user_type" => 1], "OR" =>["approved" => 0, "approved" => 2], "ORDER" =>["joined" => "DESC"]]);

        return $query;
    }    
	
	
    /**
     * Approved Voters
     *
     */
    public function approved()
    {
        $query = $this->db->select('user', '*', ["AND" => ["approved" => 1, "user_type" => 1], "ORDER" =>["joined" => "DESC"]]);

        return $query;
    }  
    /**
     * Voted
     *
     */
    public function voted()
    {
       $count = [];
        
       $voters = $this->db->select('user', '*', ["approved" => 1, "ORDER" => ["joined" => "DESC"]]);
       foreach ($voters as $row) {

         $g = $this->db->count('votes', ["userid" => $row["userid"]]);
          
          $count[] = [
               "userid" => $row["userid"],
               "g" => $g,
          ];

       }
        
      return $count;    
    }    
    public function candidates()
    {
        $query = $this->db->select('user', '*', ["AND" => ["approved" => 1, "user_type" => 2], "ORDER" =>["joined" => "DESC"]]);

        return $query;
    } 
    public function votes()
    {
        $query = $this->db->select('votes', '*', []);

        return $query;
    }  
	
}