<?php

namespace Fir\Controllers;
 
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Asp extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;
	
    public function index()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
			
		$validation = "";	
        
		/* Use Category Model */
		$categoryModel = $this->model('Category');
        $data['categories'] = $categoryModel->list();
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
		/* Use Admin Model */
        $adminModel = $this->model('Admin');;
		$data['start'] = $adminModel->start_array();       
        $now = date('Y-m-d H:i:s');
        $date_to_now = strftime("%b %d, %Y", strtotime($now));
        $data['date_to_now'] = $date_to_now;
		

		
		$has = $candidateModel->has($this->url[2]);

            // If exists
            if($has === true) {
				
				$candidate = $candidateModel->get($this->url[2]);

                /*Use User Library*/
                $user = $this->library('User');
                $data['user'] = $user->data();
                $data['user_isloggedin'] = $user->isLoggedIn();

                /* Data */
                $data["candidate"] = $candidate;
                $data["count"] = $categoryModel->count($candidate['category_id']);

                return ['content' => $this->view->render($data, 'home/candidate')];
                
			}else {
                redirect('home');
            }
    }
	
	
	//Random String
	private function rando($length = 14){
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < $length; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		return $str;
	}
}