<?php

namespace Fir\Controllers;

class Vote extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;
	
    public function index()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
        
		/* Use Category Model */
		$categoryModel = $this->model('Category');
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		
		/* Use Input Library */
		$input = $this->library('Input');
        
        //Post
        if(isset($_POST['post_vote'])){
         if ($input->exists()) {

            $validator = $this->library('Validator');

            $validation = $validator->check($_POST, [
            ]);

            if (!$validation->fails()) {

                $update = $candidateModel->vote($input->get('category'), 
                                                $input->get('candidate'),
                                                  $input->get('voter'));

                if ($update == 1) {
                    $_SESSION['message'][] = ['success', $this->lang['voted_successfully']];
                    redirect(CATEGORY_URL .'/'. $input->get('category_slug'));
                } else {
                    $_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
                    redirect(CATEGORY_URL .'/'. $input->get('category_slug'));
                }

             } else {

                 foreach ($validation->errors()->all() as $err) {
                    $str = implode(" ",$err);
                     foreach ($err as $r) {
                        $_SESSION['errors'][] = ['error', $r];
                     }	
                 }

                    redirect(CATEGORY_URL .'/'. $input->get('category_slug'));
           }

         }
        }
		
    }
	

	
	function getDomain($url){
		$pieces = parse_url($url);
		$domain = isset($pieces['host']) ? $pieces['host'] : '';
		if(preg_match('/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $regs)){
			return $regs['domain'];
		}
		return FALSE;
	}	

}