<?php

namespace Fir\Models;

class Requests extends Model {

    /**
     * Get the list of locations available
     *
     * @param   array   $params
     * @return  array
     */
    public function getLocations($params) {
        $query = $this->db->prepare("SELECT * FROM `locations` WHERE `name` = ?");
        $query->bind_param('s', $params['location']);
        $query->execute();
        $result = $query->get_result();
        $query->close();

        $data = [];

        while($row = $result->fetch_assoc()) {
            $data[$row['id']]['id']         = $row['id'];
            $data[$row['id']]['name']       = $row['name'];
            $data[$row['id']]['country']    = $row['country'];
            $data[$row['id']]['lon']        = $row['lon'];
            $data[$row['id']]['lat']        = $row['lat'];
        }

        return $data;
    }
	
    /**
     * Delete Category
     *
     */
    public function delete_category($id) {
		
		//$delete = $params['delete']; 

		 // delete the entry
		$delete = $this->db->delete('categories', ["id" => $id]);
		  
		return $delete->rowCount();  
    }
	
    /**
     * Candidate Delete
     *
     */
    public function delete_candidate($delete) {
		
		$query = $this->db->select('user', '*', ["id" => $delete]);
		foreach($query as $row){}
		
        $path = sprintf('%s/../../%s/%s/admin/users/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
		
		// unlink images
		unlink($path.$row["imagelocation"]);
		
		// delete the entry
		$delete = $this->db->delete('user', ["id" => $delete]);
		  
		return $delete->rowCount();  
    }
	
    /**
     * Candidate Delete
     *
     */
    public function delete_voting($delete) {
		
        $candidates = $this->db->select('user', '*', ["user_type" => 2]);
        foreach ($candidates as $candidate) {

            $path = sprintf('%s/../../%s/%s/admin/users/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);

            // unlink images

            if (file_exists($path.$candidate["imagelocation"]) && $candidate["imagelocation"] != "default.png") {
               unlink($path.$candidate["imagelocation"]);
            }

        }


        // delete the entry
        $delete = $this->db->delete('start', ['id' => $delete]);
        $delete_nominees = $this->db->delete('user', ["user_type" => 2]);
        $delete_categories = $this->db->delete('categories', []);
		  
		return $delete->rowCount();  
    }	
	
    /**
     * Resume Voting
     *
     */
    public function resume_voting($delete) {
		
          $update = $this->db->update('start',[
             'end' => 0,
          ],[
              'id' => $delete
            ]);

		return $update->rowCount(); 
		
    }
	
    /**
     * Finish Voting
     *
     */
    public function finish_voting($delete) {
		
          $update = $this->db->update('start',[
             'end' => 1,
             'date_ended' => date('Y-m-d'),
          ],[
              'id' => $delete
            ]);

		return $update->rowCount(); 
		
    }
	
    /**
     * Approve Voter
     *
     */
    public function approve_voter($delete) {
		
          $update = $this->db->update('user',[
             'approved' => 1,
          ],[
              'id' => $delete
            ]);

		return $update->rowCount(); 
		
    }
	
    /**
     * Decline Voter
     *
     */
    public function decline_voter($delete) {
		
          $update = $this->db->update('user',[
             'approved' => 2,
          ],[
              'id' => $delete
            ]);

		return $update->rowCount(); 
		
    }	
	
    /**
     * Delete Voter
     *
     */
    public function delete_voter($delete) {
		
		$query = $this->db->select('user', '*', ["id" => $delete]);
		foreach($query as $row){}
		
        $path = sprintf('%s/../../%s/%s/admin/users/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
		
		// unlink images
		unlink($path.$row["imagelocation"]);
		
		// delete the entry
		$delete = $this->db->delete('user', ["id" => $delete]);
		  
		return $delete->rowCount();  
    }

}