<?php
defined('FIR') OR exit();
/**
 * The template for displaying Home page content
 */
?>
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="row">
		 	
                             <div class="col-lg-12">

                               <?=$this->message()?>
                               <?=$this->validation()?>

                              </div>
                    
                                <div class="col-sm-12">
                                    <h5 class="mt-2"><?=$this->lang('settings')?></h5>
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-3 col-sm-12">
                                            <?php $selected = ($data['m'] == 'details') ? ' active' : ''; ?>
                                            <?php $image = ($data['m'] == 'image') ? ' active' : ''; ?>
                                            
                                            <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                                 <li><a href="<?=$this->siteUrl()?>/admin/<?=$this->candidate_url()?>/edit/<?=e($data['candidate']['userid'])?>/details" class="nav-link text-left<?php echo e($selected); ?>">
                                                  <em class="fa fa-fw fa-cogs text-white"></em>&nbsp;&nbsp;&nbsp;<?=$this->lang('details')?>
                                                 </a></li>  
                                                 <li><a href="<?=$this->siteUrl()?>/admin/<?=$this->candidate_url()?>/edit/<?=e($data['candidate']['userid'])?>/image" class="nav-link text-left<?php echo e($image); ?>">
                                                  <em class="fa fa-fw fa-image text-white"></em>&nbsp;&nbsp;&nbsp;<?=$this->lang('image')?>
                                                 </a></li>                                                

                                            </ul>
                                        </div>
                                        <div class="col-md-9 col-sm-12">
		                          <?php if ($data['m'] == 'details') : ?> 
                                            
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('details')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <form action="<?=$this->siteUrl()?>/admin/<?=$this->candidate_url()?>/edit/<?=e($data['candidate']['userid'])?>/details" method="post">
                                          
                                                  <input type="hidden" name="userid" value="<?=e($data['candidate']['userid'])?>" />

                                                  <div class="form-group">	
                                                    <label><?=$this->lang('name')?></label>
                                                    <input type="text" name="name" class="form-control" value="<?=e($data['candidate']['name'])?>"/>
                                                  </div>

                                                  <div class="form-group">	
                                                    <label><?=$this->lang('email')?></label>
                                                    <input type="text" name="email" class="form-control" value="<?=e($data['candidate']['email'])?>"/>
                                                  </div>

                                                  <div class="form-group">	
                                                    <label><?=$this->lang('tag_line')?></label>
                                                    <input type="text" name="tag_line" class="form-control" value="<?=e($data['candidate']['tag_line'])?>"/>
                                                  </div>
			  
                                                  <div class="form-group">	
                                                    <label><?=$this->category_name_plural()?></label>
                                                    <select class="form-control" name="category_id"> 
                                                        <?php foreach($data['categories'] as $row){ ?>
                                                           <option value="<?=e($row['id'])?>" <?=($data['candidate']['category_id'] == $row['id'] ? ' selected' : '')?>><?=e($row['title'])?></option> 
                                                        <?php } ?>   
                                                    </select>
                                                  </div>
                                                    
                                                 <div class="form-group">
                                                  <label><?=$this->lang('background')?></label>
                                                  <textarea name="background" type="text" class="form-control shadow-sm py-4" placeholder="Background" rows="7" id="summernote"><?=e($data['candidate']['background'])?></textarea>
                                                 </div>	
                                                 <div class="form-group">
                                                  <label><?=$this->lang('education')?></label>
                                                  <textarea name="education" type="text" class="form-control shadow-sm py-4" placeholder="Education" rows="7" id="summernote-1"><?=e($data['candidate']['education'])?></textarea>
                                                 </div>	
                                                 <div class="form-group">
                                                  <label><?=$this->lang('career')?></label>
                                                  <textarea name="career" type="text" class="form-control shadow-sm py-4" placeholder="Career/Business Interests" rows="7" id="summernote-2"><?=e($data['candidate']['career'])?></textarea>
                                                 </div>	

                                                    <?=$this->token()?>

                                                    <button type="submit" name="edit_details" class="btn btn-primary">Submit</button>
                                                </form>
                                            </div>
                                        </div>  
              
                                 <?php elseif ($data['m'] == 'image') : ?> 
                                        
                                        
                                        <div class="card">
                                            <div class="card-header">
                                                <h5><?=$this->lang('image')?></h5>
                                            </div>
                                            <div class="card-body">
                                                <img class="img-fluid" style="width:200px; height: 200px;" src="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/users/<?=e($data['candidate']['imagelocation'])?>" alt="logo">
                                                <br>
                                                <br>
                                                <br>
                                                <form action="<?=$this->siteUrl()?>/admin/<?=$this->candidate_url()?>/edit/<?=e($data['candidate']['userid'])?>/image" method="post" enctype="multipart/form-data">
                                          
                                                  <input type="hidden" name="userid" value="<?=e($data['candidate']['userid'])?>" />
                                                  <input type="hidden" name="imagelocation" value="<?=e($data['candidate']['imagelocation'])?>" />

                                                    <div class="form-group">
                                                        <label><?=$this->lang('choose_image')?></label>
                                                        <input type="file" name="photoimg" id="photoimg" class="form-control">
                                                    </div>

                                                    <?=$this->token()?>

                                                    <button type="submit" name="edit_image" class="btn btn-primary"><?=$this->lang('submit')?></button>
                                                </form>
                                            </div>
                                        </div>  
                                            
                                  <?php endif; ?>            
                                            
                                       
                                        </div><!-- /col-lg-9 -->
                                    </div>
                                </div>                    
                    
                    
                </div> <!-- end col -->
            </div>		
         </div>		
      </div><!-- /.content-wrapper -->