<?php
defined('FIR') OR exit();
/**
 * The template for displaying Home page content
 */
?>
<!-- [ Main Content ] start -->
    <div align="right" class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                                <?=$this->message()?>
                               <?=$this->validation()?>

                                    <div class="card">
                                        <div class="card-header">
                                            <h4><?=$this->lang('sendsms')?></h4>
                                        </div>
                                        <div class="card-block px-3 py-3">

                                            <div>
                                              <form id="sms_form" action="<?=$this->siteUrl()?>/cps/sms" method="post">
                                                <div class="row">
                                                  <div class="col-md-8">
                                                    <div class="form-group row">
                                                        <label class="col-md-3"><?=$this->lang('sms_message_recepients')?></label>
                                                        <div class="col-md-9">
                                                            <select id="send_type" name="send_type" onChange="selectSendType()"  class="form-control">
                                                              <option value="0" <?php if(isset($_POST['send_type'])){ if($_POST['send_type'] == "0"){ echo "selected"; } } ?>><?=$this->lang('send_type_0')?></option>
                                                              <option value="1" <?php if(isset($_POST['send_type'])){ if($_POST['send_type'] == "1"){ echo "selected"; } } ?>><?=$this->lang('send_type_1')?></option>
                                                              <option value="2" <?php if(isset($_POST['send_type'])){ if($_POST['send_type'] == "2"){ echo "selected"; } } ?>><?=$this->lang('send_type_2')?></option>
                                                              <option value="3" <?php if(isset($_POST['send_type'])){ if($_POST['send_type'] == "3"){ echo "selected"; } } ?>><?=$this->lang('send_type_3')?></option>
                                                              <option value="4" <?php if(isset($_POST['send_type'])){ if($_POST['send_type'] == "4"){ echo "selected"; } } ?>><?=$this->lang('send_type_4')?></option>
                                                            </select>
                                                        </div>
                                                        
                                                    </div>
                                                    
                                                  </div>
                                                </div>
                                                <div class="row mt-3">
                                                    <div class="col-md-8" >
                                                        <div class="form-group row">
                                                          <label class="col-md-3"><?=$this->lang('sms_message')?></label>
                                                          <div class="col-md-9">
                                                              <textarea class="form-control" name="sms_message" placeholder="<?=$this->lang('sms_message')?>"><?php if(isset($_POST['sms_message'])){echo $_POST['sms_message'];} ?></textarea>
                                                          </div>
                                                          
                                                        </div>
                                                      </div>
                                                </div>
                                                  
                                                  <?=$this->token()?>
                                                  
                                                  <button type="button" onClick="submitForm()" name="add_category" class="btn btn-primary"><?=$this->lang('send')?></button>
                                              </form>
                                            </div>

                                            <h5 class="mt-5"><?=$this->lang('sms_logs')?></h5>
                                            <?php if($data['admin']['user_type'] == "99"){ ?>
                                                <button class="btn btn-danger" onclick="deleteAllSMSRecords()"><i class="fa fa-times"></i> Delete all SMS Records</button>
                                            <?php } ?>
                                            <div class="table-responsive mt-3">
                                                <table class="table table-hover" id="myLab">
                                                  <thead>
                                                    <tr>
                                                     <th><?=$this->lang('sms_id')?></th>
                                                     <th><?=$this->lang('sms_mobile')?></th>
                                                     <th><?=$this->lang('sms_message_header')?></th>
                                                     <th><?=$this->lang('sms_satus')?></th>
                                                     <th><?=$this->lang('sms_date_sent')?></th>
                                                    </tr>
                                                  </thead>
                                                    <tbody>
                                                    <?php
                                                        foreach($data['sms_logs'] as $row) {

                                                        echo '<tr id="tr'.e($row["id"]).'">';
                                                        echo '<td>
                                                                  <h6>'. e($row["id"]) .'</h6>
                                                              </td>';
                                                        echo '<td>
                                                                  <h6>'. e($row["mobile_number"]) .'</h6>
                                                              </td>';
                                                        echo '<td>
                                                                  <h6>'. e($row["message"]) .'</h6>
                                                              </td>';
                                                        echo '<td>
                                                                  <h6>'. e(($row["status"] == "1") ? $this->lang('sms_success_tbl') : $this->lang('sms_failed_tbl')) .'</h6>
                                                              </td>';
                                                        echo '<td>
                                                                  <h6>'. e($row["date_added"]) .'</h6>
                                                              </td>';
                                                        
                                                        echo '</tr>';
                                                       }
                                                    ?>
                                                    </tbody>
                                                </table>
                                            </div>

                                            
                                        </div>
                                    </div>   

                                        
      
            </div>
        </div>
    </div>
    <script type="text/javascript">
      var stringRecepients = "";
      function addRecepient(number){
        stringRecepients += number + ";";
        document.getElementById("recepients_list").value = stringRecepients;
      }

      function submitForm(){
        document.getElementById("sms_form").submit();
      }

      function selectSendType(){
        var sendType = document.getElementById("send_type").value;
        document.getElementById("manual_pick").style.display = "none";
        if(sendType == "5"){
          document.getElementById("manual_pick").style.removeProperty('display');
        }
      }
      
    <?php if($data['admin']['user_type'] == "99"){ ?>
        function deleteAllSMSRecords(){
          swal({
        	  title: "<?=$this->lang('sms_message_header')?>",
        	  text: "<?=$this->lang('sms_delete_all')?>.",
        	  icon: "warning",
        	  buttons: ["<?=$this->lang('cancel')?>", "<?=$this->lang('yes')?>"],
        	  dangerMode: true,
        	}).then((willDelete) => {
        		  if (willDelete) {    
        					  
        		    $("#sms_form").attr('action', "<?=$this->siteUrl()?>/cps/deleteallsms");
                    $("#sms_form").submit();
        			 
        		  }
           });
          
        }
    <?php } ?>
      
      
    </script>
    <!-- [ Main Content ] end -->