<?php

namespace Fir\Controllers;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class Cps extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;

    public function index() {
        if (isset($this->url[1]) && $this->url[1] == 'lang') {
            $this->updateLanguage($this->url[2]);
        }
        redirect('cps/login');
    }
	
    public function logout() {
        $admin = $this->library('Admin');
		
		$admin->logout();
		
		redirect('cps/login');
    }
	

    /**
     * @param $language string
     */
    private function updateLanguage($language)
    {
        setcookie('lang', $language, time() + (10 * 365 * 24 * 60 * 60), COOKIE_PATH);
        redirect('cps/dashboard');
    }
	
    public function login()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
			
		$validation = "";	

		/* Use Admin Model */
        $admin = $this->library('Admin');
		if($admin->isLoggedIn() === true):
		 redirect('cps/dashboard');
		endif;
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();

        // If the user tries to log-in
			if(isset($_POST['login'])) {
		
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'email' => [
				 'required' => true,
				 'minlength' => 2,
				 'maxlength' => 200
			   ],
			  'password' => [
				 'required' => true,
				 'minlength' => 2,
				 'maxlength' => 200
			   ]
			]);
				 
			if (!$validation->fails()) {
					$email = $_POST['email'];
					$password = $_POST['password'];
					$remember = null;
					
					if(isset($_POST['remember'])) {
					  $remember = ($_POST['remember'] === 'on') ? true : false;
					}

					// Attempt to auth the user
					$auth = $admin->login(
						 $email,
						 $password,
						 $remember
					  );

					// If the user has been logged-in
					if($auth) {
						// redirect('cps/dashboard');
						$_SESSION['is_admin'] = 1;
						$_SESSION['email'] = $email;
						$_SESSION['password'] = $password;
						$_SESSION['remember'] = $remember;
						redirect('otp');
					}
					// If the user could not be logged-in
					elseif(isset($_POST['login'])) {
						$_SESSION['message'][] = ['error', $this->lang['invalid_user_pass']];
					}

				}
			else {
			 foreach ($validation->errors()->all() as $err) {
				$str = implode(" ",$err);
				 foreach ($err as $r) {
					$_SESSION['errors'][] = ['error', $r];
				 }	
			 }
			}
		}	

        return ['content' => $this->view->render($data, 'admin/login')];
    }

    public function dashboard() {
        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		$data['themes'] = $this->getThemes();
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
		/* Use Admin Model */
        $adminModel = $this->model('Admin');
		$data['count_voters'] = $adminModel->count_voters();
		$data['count_candidates'] = $adminModel->count_candidates();
		$data['count_categories'] = $adminModel->count_categories();
		$data['has_start'] = $adminModel->has_start();
		$data['start'] = $adminModel->start();
		$data['language_use'] = $this->language;
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		//Update
		if(isset($_POST['edit_voting'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
				  'title' => [
					 'required' => true,
				  ],
				  'date_to_start' => [
					 'required' => true,
				  ],
				  'date_to_end' => [
					 'required' => true,
				  ],
				  'description' => [
					 'required' => true,
				  ],
			]);
				 
			if (!$validation->fails()) {
				
				$update = $adminModel->update_voting($input->get('title'), $input->get('date_to_start'), $input->get('date_to_end'), $input->get('description'), $input->get('id'), $input->get('en_date_to_start'), $input->get('en_date_to_end'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
					redirect('cps/dashboard');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
					redirect('cps/dashboard');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
					redirect('cps/dashboard');
		   }

		 }
		}		
		//Start
		if(isset($_POST['start_voting'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
				  'title' => [
					 'required' => true,
				  ],
				  'date_to_start' => [
					 'required' => true,
				  ],
				  'date_to_end' => [
					 'required' => true,
				  ],
				  'description' => [
					 'required' => true,
				  ],
			]);
				 
			if (!$validation->fails()) {
				
				$insert = $adminModel->start_voting($input->get('title'), $input->get('date_to_start'), $input->get('date_to_end'), $input->get('description'));
					
				if ($insert == 1) {
                    $_SESSION['message'][] = ['success', $this->lang['details_saved']];
					redirect('cps/dashboard');
                } else {
                    $_SESSION['message'][] = ['warning', $this->lang['error_when_saving']];
					redirect('cps/dashboard');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
					redirect('cps/dashboard');
		   }

		 }
		}

        
		
        return ['content' => $this->view->render($data, 'admin/dashboard')];
    }

    /**
     * Get the available Themes
     */
    private function getThemes() {
        $path = sprintf('%s/../../%s/%s/', __DIR__, PUBLIC_PATH, THEME_PATH);

        $themes = scandir($path);

        $output = [];
        foreach($themes as $theme) {
            // Check if the theme has an info.php file a && file_exists($path.$theme.'/icon.png)nd a thumbnail
            if(file_exists($path.$theme.'/info.php') && file_exists($path.$theme.'/icon.png')) {
                // Store the theme information
                require($path.$theme.'/info.php');
                $output[$theme]['name']     = $name;
                $output[$theme]['author']   = $author;
                $output[$theme]['url']      = $url;
                $output[$theme]['version']  = $version;
                $output[$theme]['bootstrap']  = $bootstrap;
                $output[$theme]['path']     = $theme;
            }
        }

        return $output;
    }


    public function profile() {
        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* URL */
		$data['m'] = $this->url[2];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		/* Use Admin Model */
		$adminModel = $this->model('Admin');
		
		
		//Edit Profile Data
		if(isset($_POST['profile'])){
		 if ($input->exists()) {
			
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'username' => [
				 'required' => true,
				 'maxlength' => 20,
				 'minlength' => 2
			  ],
			  'name' => [
				 'required' => true,
				 'maxlength' => 100,
				 'minlength' => 2
			  ],
			  'email' => [
				 'required' => true,
				 'maxlength' => 255,
				 'email' => true
			   ]
			]);
				 
			if (!$validation->fails()) {
				
				
				$update = $adminModel->profileDetails($input->get('name'), $input->get('username'), $input->get('email'), $data['admin']['adminid']);
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
				    redirect('cps/profile/details');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
				    redirect('cps/profile/details');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('cps/profile/details');
		   }
         }
		}	

		/*Edit Image Data*/
		if(isset($_POST['picture'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['admin']['imagelocation'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $adminModel->profileImage($fileName, $data['admin']['adminid']); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('cps/profile/image');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('cps/profile/image');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('cps/profile/image');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('cps/profile/image');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('cps/profile/image');
			  }	
			
		 }	
		}

		/*Edit Password Data*/
		if(isset($_POST['password'])){
		 if ($input->exists()) {
		 
			
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'password_current' => [
				 'required' => true,
				 'maxlength' => 300
			  ],
			   'password_new' => [
				 'required' => true,
				 'minlength' => 6
			   ],
			   'password_new_again' => [
				 'required' => true,
				 'match' => 'password_new'
			   ]
			]);
				 
			if (!$validation->fails()) {

				if (password_verify($input->get('password_current'), $data['admin']['password'])) {
					
					/* Hash Password */
					$password = password_hash($input->get('password_new'), PASSWORD_DEFAULT);
					
					$update = $adminModel->password($password, $data['admin']['adminid']);
						
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('cps/profile/password');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('cps/profile/password');
					}
					
				} else {
					
					$_SESSION['message'][] = ['error', $this->lang['current_password_does_not_match']];
						redirect('cps/profile/password');
				 
				}
			  
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('cps/profile/password');
		     }	
		  
			
		 }
		}		
		
        return ['content' => $this->view->render($data, 'admin/profile')];
    }
	
	
	/**
	 * Settings Function
	 */
    public function settings() {
        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* URL */
		$data['m'] = $this->url[2];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		/* Use Admin Model */
		$adminModel = $this->model('Admin');
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
        
        $dir = "../app/languages/";

        // Sort in ascending order - this is default
        $langs = scandir($dir);
        $data['language_list'] = array();
        foreach($langs as $rows){
            if($rows != "." && $rows != ".."){
                array_push($data['language_list'], substr($rows, 0, -4));
            }
            
        }

		//Edit Site Settings Data
		if(isset($_POST['postsite'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'sitename' => [
				 'required' => true,
				 'minlength' => 2
			  ],
			  'title' => [
				 'required' => true,
				 'minlength' => 2
			  ],
			  'description' => [
				 'required' => true,
				 'minlength' => 3
			   ],
			  'keywords' => [
				 'required' => true,
				 'minlength' => 3
			   ],
			  'timezone' => [
				 'required' => true,
			   ],
			   'instruction' => [
				 'required' => true,
			   ]
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->siteDetails($input->get('sitename'), $input->get('title'), $input->get('description'), $input->get('keywords'), $input->get('timezone'), $input->get('instruction'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
					redirect('cps/settings/site');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
					redirect('cps/settings/site');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('cps/settings/site');
		   }

		 }
		}		

		/*Edit Image Data*/
		if(isset($_POST['postlogo'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['logo'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteLogo($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('cps/settings/logo');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('cps/settings/logo');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('cps/settings/logo');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('cps/settings/logo');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('cps/settings/logo');
			  }	
			
		 }	
		}

		/*Edit Favicon*/
		if(isset($_POST['postfavicon'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['favicon'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteFavicon($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('cps/settings/favicon');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('cps/settings/favicon');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('cps/settings/favicon');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('cps/settings/favicon');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('cps/settings/favicon');
			  }	
			
		 }	
		}

		//Edit Analytics
		if(isset($_POST['postanalytics'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'analytics' => [
				 'required' => true,
			  ],
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->siteAnalytics($input->get('analytics'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
					redirect('cps/settings/analytics');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
					redirect('cps/settings/analytics');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('cps/settings/analytics');
		   }

		 }
		}

		//Edit Votes
		if(isset($_POST['post_votes'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->siteVotes($input->get('show_votes'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
					redirect('cps/settings/votes');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
					redirect('cps/settings/votes');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('cps/settings/votes');
		   }

		 }
		}

		//Edit Email
		if(isset($_POST['post_email'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'smtp_host' => [
				 'required' => true,
			  ],
			  'smtp_username' => [
				 'required' => true,
			  ],
			  'smtp_password' => [
				 'required' => true,
			  ],
			  'smtp_encryption' => [
				 'required' => true,
			  ],
			  'smtp_port' => [
				 'required' => true,
			  ],
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->email($input->get('smtp_host'), $input->get('smtp_username'), $input->get('smtp_password'), $input->get('smtp_encryption'), $input->get('smtp_port'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
				    redirect('cps/settings/email');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
				    redirect('cps/settings/email');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('cps/settings/email');
		   }

		 }
		}
		
		//Edit SMS
		if(isset($_POST['post_sms'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'sms_key' => [
				 'required' => true,
			  ],
			  'sms_from' => [
				 'required' => true,
			  ],
			  'sms_country_code' => [
				 'required' => true,
			  ]
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->sms($input->get('sms_key'), $input->get('sms_from'), $input->get('sms_country_code'));
					
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
				    redirect('cps/settings/sms');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
				    redirect('cps/settings/sms');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('cps/settings/sms');
		   }

		 }
		}
		
		//Edit Other Settings
		if(isset($_POST['post_other_settings'])){
		 if ($input->exists()) {

			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'sms_limit' => [
				 'required' => true,
			  ],
			  'cpr_limit' => [
				 'required' => true,
			  ]
			]);
				 
			if (!$validation->fails()) {
				
				$update = $settingsModel->otherSettings($input->get('allow_voter_reg'), $input->get('allow_cand_reg'), $input->get('sms_limit'), $input->get('cpr_limit'), $input->get('language'));
				
				if(isset($_COOKIE['lang'])){
				    unset($_COOKIE['lang']);
				}
				
				setcookie('lang', $input->get('language'), time() + (10 * 365 * 24 * 60 * 60), COOKIE_PATH);
				
				if ($update == 1) {
					$_SESSION['message'][] = ['success', $this->lang['details_updated']];
				    redirect('cps/settings/other_settings');
				} else {
					$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
				    redirect('cps/settings/other_settings');
				}
					
			 } else {

				 foreach ($validation->errors()->all() as $err) {
					$str = implode(" ",$err);
					 foreach ($err as $r) {
						$_SESSION['errors'][] = ['error', $r];
					 }	
				 }
				 
				 redirect('cps/settings/other_settings');
		   }

		 }
		}

		/*Edit Home Bg*/
		if(isset($_POST['post_home'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['home_bg'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteHomeBg($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('cps/settings/home');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('cps/settings/home');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('cps/settings/home');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('cps/settings/home');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('cps/settings/home');
			  }	
			
		 }	
		}

		/*Edit Home Bg*/
		if(isset($_POST['post_login'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['login_bg'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteLoginBg($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('cps/settings/login');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('cps/settings/login');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('cps/settings/login');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('cps/settings/login');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('cps/settings/login');
			  }	
			
		 }	
		}

		/*Edit Hero Bg*/
		if(isset($_POST['post_hero'])){
		 if ($input->exists()) {
			
			$valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");
		   
			$name = $_FILES['photoimg']['name'];
			$size = $_FILES['photoimg']['size'];

			if(!empty($name))
			{
			  
			  $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);
			  
              // If there is no error during upload and the file is PNG
			  if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
			   {
				 $fileName = $this->rando().'.'.$fileFormat;
				 // If the file can't be written on the disk (will return 0)
                 $path = sprintf('%s/../../%s/%s/admin/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);
				 

				 if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
				  {

					// Get the old image
					$oldFileName = $data['settings']['hero_bg'] ?? null;

					// Remove the old variant of the image
					if($oldFileName && $oldFileName != $fileName) {
						unlink($path.$oldFileName);
					}
					$update = $settingsModel->siteHeroBg($fileName); 
					
					if ($update == 1) {
						$_SESSION['message'][] = ['success', $this->lang['details_updated']];
						redirect('cps/settings/hero');
					} else {
						$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
						redirect('cps/settings/hero');
					}		  
							
				  }else{
					$_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
						redirect('cps/settings/hero');	
				  }
			   }else{
					$_SESSION['message'][] = ['error', $this->lang['format_error']];
						redirect('cps/settings/hero');			
			   }
			  }else{
					$_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
						redirect('cps/settings/hero');
			  }	
			
		 }	
		}
				
		
		
        return ['content' => $this->view->render($data, 'admin/settings')];
    }
    

    /**
     * Categories
     */
    public function category()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use Category Model */
		$categoryModel = $this->model('Category');
		
		/* Use Input Library */
		$input = $this->library('Input');
        
        // Edit Page
        if(isset($this->url[2]) && $this->url[2] == 'add') {			
			

		
				//Add Currency Data
				if(isset($_POST['add_category'])){
				 if ($input->exists()) {

					$validator = $this->library('Validator');
					
					$validation = $validator->check($_POST, [
						  'title' => [
							 'required' => true,
						  ],
						  'to_vote' => [
							 'required' => true,
						  ],
						  'to_vote_max' => [
							 'required' => true,
						  ],
						  'en_date_to_start' => [
							 'required' => true,
						  ],
						  'en_date_to_end' => [
							 'required' => true,
						  ]
					]);
						 
					if (!$validation->fails()) {
					   
						$slug = $this->slugify($input->get('title'));
						
						$insert = $categoryModel->add($input->get('title'), $this->uniqueid(),$input->get('to_vote'),$input->get('en_date_to_start'),$input->get('en_date_to_end'),$input->get('to_vote_max'));
							
						if ($insert == 1) {
							$_SESSION['message'][] = ['success', $this->lang['details_saved']];
							redirect('cps/'. CATEGORY_URL .'/add');
						} else {
							$_SESSION['message'][] = ['warning', $this->lang['error_when_saving']];
							redirect('cps/'. CATEGORY_URL .'/add');
						}
							
					 } else {

						 foreach ($validation->errors()->all() as $err) {
							$str = implode(" ",$err);
							 foreach ($err as $r) {
								$_SESSION['errors'][] = ['error', $r];
							 }	
						 }
                        
							redirect('cps/'. CATEGORY_URL .'/add');
				   }

				 }
				}
				
                return ['content' => $this->view->render($data, 'admin/category_add')];
                
        }elseif(isset($this->url[2]) && $this->url[2] == 'list'){
            
                $data['categories'] = $categoryModel->list();
				
                return ['content' => $this->view->render($data, 'admin/category_list')];
            
        }elseif(isset($this->url[2]) && $this->url[2] == 'graphs'){		
			
            $has = $categoryModel->has($this->url[3]);
            $data['language'] = $this->language;

            // If the currency requested exists
            if($has === true) {
                
                $data["category"] = $categoryModel->get($this->url[3]);
				
                $graphs = $categoryModel->graphs($this->url[3]);  
                
                for($i = 0; $i < sizeof($graphs); $i++){
                    $data['graphs'][$i]['label'] = str_replace("votes",$this->lang['graphs_votes'],$graphs[$i]['label']);
                    $data['graphs'][$i]['y'] = $graphs[$i]['y'];
                }
				
                return ['content' => $this->view->render($data, 'admin/category_graphs')];
				
            } else {
                redirect('cps/'. CATEGORY_URL .'/list');
            }
            
        }elseif(isset($this->url[2]) && $this->url[2] == 'edit') {			
			
            $has = $categoryModel->has($this->url[3]);

            // If the currency requested exists
            if($has === true) {
				
                $data["category"] = $categoryModel->get($this->url[3]);
			

		
				//Add Currency Data
				if(isset($_POST['edit_category'])){
				 if ($input->exists()) {

					$validator = $this->library('Validator');
					
					$validation = $validator->check($_POST, [
						  'title' => [
							 'required' => true,
						  ],
					]);
						 
					if (!$validation->fails()) {
					   
						$slug = $this->slugify($input->get('title'));
						
						$update = $categoryModel->update($input->get('title'), $this->uniqueid(), $input->get('id'), $input->get('to_vote'),$input->get('en_date_to_start'),$input->get('en_date_to_end'),$input->get('to_vote_max'));
							
						if ($update == 1) {
							$_SESSION['message'][] = ['success', $this->lang['details_updated']];
							redirect('cps/'. CATEGORY_URL .'/edit/'. $input->get('id'));
						} else {
							$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
							redirect('cps/'. CATEGORY_URL .'/edit/'. $input->get('id'));
						}
							
					 } else {

						 foreach ($validation->errors()->all() as $err) {
							$str = implode(" ",$err);
							 foreach ($err as $r) {
								$_SESSION['errors'][] = ['error', $r];
							 }	
						 }
                        
							redirect('cps/'. CATEGORY_URL .'/edit/'. $input->get('id'));
				   }

				 }
				}               
				
                return ['content' => $this->view->render($data, 'admin/category_edit')];
				
            } else {
                redirect('cps/'. CATEGORY_URL .'/list');
            }
        }       
    }
	
    

    /**
     * Candidates
     */
    public function candidate()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		/* Use Category Model */
		$categoryModel = $this->model('Category');
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
		/* Use Input Library */
		$input = $this->library('Input');
		
        
        // Edit Page
        if(isset($this->url[2]) && $this->url[2] == 'add') {
            
           $data['categories'] = $categoryModel->list();	
            
                //Add Candidate Data
                if(isset($_POST['add_candidate'])){
                 if ($input->exists()) {

                    $validator = $this->library('Validator');

                    $validation = $validator->check($_POST, [
                          'name' => [
                             'required' => true,
                          ],
                          'tag_line' => [
                             'required' => true,
                          ],
                          'email' => [
                             'required' => true,
                             'email' => true,
                          ]
                    ]);
                    
                    

                    if (!$validation->fails()) {

                        /* HasH Password */
                        $password = password_hash(PASSWORD, PASSWORD_DEFAULT);

                        /* Unique ID */	
                        $userid = $this->uniqueid();


                        $valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");

                        $name = $_FILES['photoimg']['name'];
                        $size = $_FILES['photoimg']['size'];

                        if(!empty($name))
                        {

                          $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);

                          // If there is no error during upload and the file is PNG
                          if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
                           {
                             $fileName = date('y.m.d.H.i') . "-" . microtime(true) . "-" . mt_rand(0, 99999999) . '.' . $fileFormat;
                             // If the file can't be written on the disk (will return 0)
                             $path = sprintf('%s/../../%s/%s/admin/users/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);


                             if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
                              {

                                $insert = $candidateModel->add($userid, $input->get('name'), $input->get('email'), $input->get('cpr'), $input->get('mobile'), $password, $input->get('tag_line'), $input->get('category_id'), $fileName);

                                if ($insert == 1) {
                                    $_SESSION['message'][] = ['success', $this->lang['details_saved']];
                                    redirect('cps/candidate/add');
                                } else {
                                    $_SESSION['message'][] = ['warning', $this->lang['error_when_saving']];
                                    // redirect('cps/candidate/add');
                                   return ['content' => $this->view->render($data, 'admin/candidate_add')];
                                }


                              }else{
                                $_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
                                    // redirect('cps/candidate/add');
                                   return ['content' => $this->view->render($data, 'admin/candidate_add')];
                              }
                           }else{
                                $_SESSION['message'][] = ['error', $this->lang['format_error']];
                                    // redirect('cps/candidate/add');
                                   return ['content' => $this->view->render($data, 'admin/candidate_add')];
                           }
                          }else{
                              
                                $_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
                                    // redirect('cps/candidate/add');
                                   return ['content' => $this->view->render($data, 'admin/candidate_add')];
                          }					


                     } else {

                         foreach ($validation->errors()->all() as $err) {
                            $str = implode(" ",$err);
                             foreach ($err as $r) {
                                $_SESSION['errors'][] = ['error', $r];
                             }	
                         }
                        
                                   // redirect('cps/candidate/add');
                                   return ['content' => $this->view->render($data, 'admin/candidate_add')];
                   }

                 }
                }
				
                return ['content' => $this->view->render($data, 'admin/candidate_add')];
                
        }elseif(isset($this->url[2]) && $this->url[2] == 'list'){
            
                $data['categories'] = $categoryModel->list();	
            
                $data['candidates'] = $candidateModel->list();
				
                return ['content' => $this->view->render($data, 'admin/candidate_list')];
            
        }elseif(isset($this->url[2]) && $this->url[2] == 'approve'){
            
                $data['categories'] = $categoryModel->list();	
            
                $data['candidates'] = $candidateModel->approve();
        
                if(isset($this->url[3]) && $this->url[3] == '1'){ 

                    $m = $candidateModel->getId($this->url[4]);

                    $mail = new PHPMailer;

                    //Server settings
                    $mail->isSMTP();                                      // Set mailer to use SMTP
                    $mail->Host = $data['settings']['smtp_host'];  // Specify main and backup SMTP servers
                    $mail->SMTPAuth = true;                               // Enable SMTP authentication
                    $mail->Username = $data['settings']['smtp_username'];                 // SMTP username
                    $mail->Password = $data['settings']['smtp_password'];                           // SMTP password
                    $mail->SMTPSecure = $data['settings']['smtp_encryption'];                                  // Enable TLS encryption, `ssl` also accepted				
                    $mail->Port = $data['settings']['smtp_port'];                                    // TCP port to connect to	

                     $mail->setFrom($data['settings']['smtp_username'], $data['settings']['sitename']);
                     $mail->addAddress($m["email"], $m["name"]);
                     $mail->Subject = "Candidate Approved - " .$data['settings']['sitename'];
                     $mail->isHTML(true);
                     $mail->Body = "
                           <p>Hello ". $m["name"] ."</p>
                           <p>Your Candidate account has been approved, voters can now vote for you.</p>
                           <p>Click following link to login</p> 
                           <a href='". URL_PATH ."'>Login</a>
                           <p>Thank you.</p>
                     ";
                     $mail->send();	   	   

					 redirect('cps/candidate/approve');

                }elseif(isset($this->url[3]) && $this->url[3] == '2'){     

                    $m = $candidateModel->getId($this->url[4]);

                    $mail = new PHPMailer;

                    //Server settings
                    $mail->isSMTP();                                      // Set mailer to use SMTP
                    $mail->Host = $data['settings']['smtp_host'];  // Specify main and backup SMTP servers
                    $mail->SMTPAuth = true;                               // Enable SMTP authentication
                    $mail->Username = $data['settings']['smtp_username'];                 // SMTP username
                    $mail->Password = $data['settings']['smtp_password'];                           // SMTP password
                    $mail->SMTPSecure = $data['settings']['smtp_encryption'];                                  // Enable TLS encryption, `ssl` also accepted				
                    $mail->Port = $data['settings']['smtp_port'];                                    // TCP port to connect to	

                     $mail->setFrom($data['settings']['smtp_username'], $data['settings']['sitename']);
                     $mail->addAddress($m["email"], $m["name"]);
                     $mail->Subject = "Candidate Declined - " .$data['settings']['sitename'];
                     $mail->isHTML(true);
                     $mail->Body = "
                           <p>Hello ". $m["name"] ."</p>
                           <p>Your account has been declined, voters cannot vote for you.</p>
                           <p>Thank you.</p>
                     ";
                     $mail->send();	   

					 redirect('cps/candidate/approve');

                }
				
                return ['content' => $this->view->render($data, 'admin/candidate_approve')];
            
        }elseif(isset($this->url[2]) && $this->url[2] == 'edit') {			
			
            $has = $candidateModel->has($this->url[3]);
		
            /* URL */
            $data['m'] = $this->url[4];
            
            $data['categories'] = $categoryModel->list();	

            // If the currency requested exists
            if($has === true) {
				
                $data["candidate"] = $candidateModel->get($this->url[3]);
			

		
				//Add Currency Data
				if(isset($_POST['edit_details'])){
				 if ($input->exists()) {

					$validator = $this->library('Validator');
					
					$validation = $validator->check($_POST, [
                          'name' => [
                             'required' => true,
                          ],
                          'tag_line' => [
                             'required' => true,
                          ],
                          'email' => [
                             'required' => true,
                             'email' => true,
                          ]	
					]);
						 
					if (!$validation->fails()) {
						
						$update = $candidateModel->update($input->get('name'), 
                                                          $input->get('email'),
                                                          $input->get('cpr'),                     $input->get('mobile'),     $input->get('tag_line'), 
                                                          $input->get('category_id'), 
                                                          $input->get('background'), 
                                                          $input->get('education'), 
                                                          $input->get('career'), 
                                                          $input->get('userid'));
							
						if ($update == 1) {
							$_SESSION['message'][] = ['success', $this->lang['details_updated']];
							redirect('cps/candidate/edit/'. $input->get('userid') .'/details');
						} else {
							$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
							redirect('cps/candidate/edit/'. $input->get('userid') .'/details');
						}
							
					 } else {

						 foreach ($validation->errors()->all() as $err) {
							$str = implode(" ",$err);
							 foreach ($err as $r) {
								$_SESSION['errors'][] = ['error', $r];
							 }	
						 }
                        
							redirect('cps/candidate/edit/'. $input->get('userid') .'/details');
				   }

				 }
				}
                
                /*Edit Image*/
                if(isset($_POST['edit_image'])){
                 if ($input->exists()) {

                    $valid_formats = array("jpg", "jpeg", "png", "gif", "bmp");

                    $name = $_FILES['photoimg']['name'];
                    $size = $_FILES['photoimg']['size'];

                    if(!empty($name))
                    {

                      $fileFormat = pathinfo($_FILES['photoimg']['name'], PATHINFO_EXTENSION);

                      // If there is no error during upload and the file is PNG
                      if($_FILES['photoimg']['error'] == 0 && in_array($fileFormat, $valid_formats))
                       {
                         $fileName = $this->rando().'.'.$fileFormat;
                         // If the file can't be written on the disk (will return 0)
                         $path = sprintf('%s/../../%s/%s/admin/users/', __DIR__, PUBLIC_PATH, UPLOADS_PATH);


                         if(move_uploaded_file($_FILES['photoimg']['tmp_name'], $path.$fileName))
                          {

							// Get the old image
							$oldFileName = $input->get('imagelocation') ?? null;

							// Remove the old variant of the image
							if($input->get('imagelocation') != "default.png"):
								if($oldFileName && $oldFileName != $fileName) {
									unlink($path.$oldFileName);
								}
							endif;	
						
							$update = $candidateModel->changeImage($fileName, $input->get('userid'));

                            if ($update == 1) {
                                $_SESSION['message'][] = ['success', $this->lang['details_updated']];
							    redirect('cps/candidate/edit/'. $input->get('userid') .'/image');
                            } else {
                                $_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
							    redirect('cps/candidate/edit/'. $input->get('userid') .'/image');
                            }		  

                          }else{
                            $_SESSION['message'][] = ['error', $this->lang['unable_to_upload_image']];
							    redirect('cps/candidate/edit/'. $input->get('userid') .'/image');
                          }
                       }else{
                            $_SESSION['message'][] = ['error', $this->lang['format_error']];
							    redirect('cps/candidate/edit/'. $input->get('userid') .'/image');
                       }
                      }else{
                            $_SESSION['message'][] = ['error', $this->lang['image_not_selected']];
							    redirect('cps/candidate/edit/'. $input->get('userid') .'/image');
                      }	

                 }	
                } 
				
                return ['content' => $this->view->render($data, 'admin/candidate_edit')];
				
            } else {
                redirect('cps/candidate/list');
            }
        }       
    }
	


    /**
     * Verify Voters
     */
    public function verify_voters()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
            
        $data['voters'] = $userModel->list();	
        
        if(isset($this->url[2]) && $this->url[2] == '1'): 
            
            $m = $userModel->getId($this->url[3]);
            
            $mail = new PHPMailer;

            //Server settings
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $data['settings']['smtp_host'];  // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                               // Enable SMTP authentication
            $mail->Username = $data['settings']['smtp_username'];                 // SMTP username
            $mail->Password = $data['settings']['smtp_password'];                           // SMTP password
            $mail->SMTPSecure = $data['settings']['smtp_encryption'];                                  // Enable TLS encryption, `ssl` also accepted				
            $mail->Port = $data['settings']['smtp_port'];                                    // TCP port to connect to	

             $mail->setFrom($data['settings']['smtp_username'], $data['settings']['sitename']);
             $mail->addAddress($m["email"], $m["name"]);
             $mail->Subject = "Voter Approved - " .$data['settings']['sitename'];
             $mail->isHTML(true);
             $mail->Body = "
                   <p>Hello ". $m["name"] ."</p>
                   <p>Your account has been approved, now login to Vote.</p>
                   <p>Click following link to login</p> 
                   <a href='". URL_PATH ."'>Login</a>
                   <p>Thank you.</p>
             ";
             $mail->send();	   
            
            redirect('cps/verify_voters');
            
        elseif(isset($this->url[2]) && $this->url[2] == '2'):     
            
            $m = $userModel->getId($this->url[3]);
            
            $mail = new PHPMailer;

            //Server settings
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $data['settings']['smtp_host'];  // Specify main and backup SMTP servers
            $mail->SMTPAuth = true;                               // Enable SMTP authentication
            $mail->Username = $data['settings']['smtp_username'];                 // SMTP username
            $mail->Password = $data['settings']['smtp_password'];                           // SMTP password
            $mail->SMTPSecure = $data['settings']['smtp_encryption'];                                  // Enable TLS encryption, `ssl` also accepted				
            $mail->Port = $data['settings']['smtp_port'];                                    // TCP port to connect to	

             $mail->setFrom($data['settings']['smtp_username'], $data['settings']['sitename']);
             $mail->addAddress($m["email"], $m["name"]);
             $mail->Subject = "Voter Declined - " .$data['settings']['sitename'];
             $mail->isHTML(true);
             $mail->Body = "
                   <p>Hello ". $m["name"] ."</p>
                   <p>Your account has been declined, you cannot vote.</p>
                   <p>Thank you.</p>
             ";
             $mail->send();	   
            
            redirect('cps/verify_voters');   
            
        endif;        

        return ['content' => $this->view->render($data, 'admin/voters_list')];    
    }

    /**
     * Voters
     */
    public function voters()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
            
        $data['voters'] = $userModel->approved();	
        $data['voted'] = $userModel->voted();	

        return ['content' => $this->view->render($data, 'admin/voters_approved_with_sms')];    
    }
    
    /**
     * Add Voters
     */
    public function addVoters()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
            
        $data['voters'] = $userModel->approved();	
        $data['voted'] = $userModel->voted();	

        return ['content' => $this->view->render($data, 'admin/voters_add')];    
    }

    /**
     * Voter Results
     */
    public function voter_results()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
            
        $data['voters'] = $userModel->approved();	
        $data['candidates'] = $userModel->candidates();	
        $data['votes'] = $userModel->votes();	

        return ['content' => $this->view->render($data, 'admin/voter_results')];    
    }

    /**
     * Results
     */
    public function results()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use User Model */
		$userModel = $this->model('User');
		
		/* Use Input Library */
		$input = $this->library('Input');
		
		/* Use Candidate Model */
		$candidateModel = $this->model('Candidate');
		/* Use Category Model */
		$categoryModel = $this->model('Category');
        $data['categories'] = $categoryModel->list();	
        $data['candidates'] = $candidateModel->list();
        $data["count"] = $candidateModel->count();

        return ['content' => $this->view->render($data, 'admin/results')];    
    }
	

	
	//Random String
	private function rando($length = 14){
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < $length; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		return $str;
	}
	
	//Random String
	function uniqueid()
	{
		$un = substr(number_format(time() * rand(),0,'',''),0,12);
		return $un;
	}

		/**
	 * Return the slug of a string to be used in a URL.
	 *
	 * @return String
	 */
	private function slugify($text){
		// replace non letter or digits by -
// 		$text = preg_replace('~[^\pL\d]+~u', '-', $text);

// 		// transliterate
// 		$text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);

// 		// remove unwanted characters
// 		$text = preg_replace('~[^-\w]+~', '', $text);

// 		// trim
// 		$text = trim($text, '-');

// 		// remove duplicated - symbols
// 		$text = preg_replace('~-+~', '-', $text);

// 		// lowercase
// 		$text = strtolower($text);

// 		if (empty($text)) {
// 		  return 'n-a';
// 		}

        

		return $text;
	}

	/**
     * SMS
     */
    public function sms()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use User Model */
		$adminModel = $this->model('Admin');
		/* Use Category Model */
		$categoryModel = $this->model('Category');
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();

		$data['categories'] = $categoryModel->list();	
            
        $data['users'] = $adminModel->select_all_users();
        

        if(isset($_POST['send_type'])){
        	$sendType = $_POST['send_type'];
        	$mobiles = null;

        	$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'sms_message' => [
				 'required' => true,
				 'minlength' => 1,
				 'maxlength' => 160
			   ]
			]);
				 
			if (!$validation->fails()) {
				if($sendType == "5"){
	        		$mobiles = explode(";", $_POST["recepients_list"]);
	        	}else{
	        		$mobiles = $adminModel->select_mobile($sendType);
	        	}
	        	$final_values = array();
	        	foreach ($mobiles as $key => $value) {
	        		if(strlen($value) == 8){
	        			if(is_numeric($value)){
	        				array_push($final_values, (int)($data['settings']['sms_country_code'] . $value));
	        			}
	        		}
	        		
	        	}

				$MessageBird = new \MessageBird\Client($data['settings']['sms_key']);
				$Message = new \MessageBird\Objects\Message();
				$Message->originator = $data['settings']['sms_from'];
				$Message->recipients = $final_values;
				$Message->datacoding = 'unicode';
				$Message->body = $_POST['sms_message'];
	    
				try{
					$MessageBird->messages->create($Message);

					foreach ($final_values as $key => $value) {
						$adminModel->insert_sms_logs($value,$_POST['sms_message'],1);
					}

					$_SESSION['message'][] = ['success', $this->lang['sms_succ']];
				}catch(Exception $e){
					//echo $e->getMessage();
					foreach ($final_values as $key => $value) {
						$adminModel->insert_sms_logs($value,$_POST['sms_message'],0);
					}
				}
			}

        }

        $data['sms_logs'] = $adminModel->select_sms_logs();

        return ['content' => $this->view->render($data, 'admin/sms')];    
    }
    
    public function deleteallsms()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use User Model */
		$adminModel = $this->model('Admin');
		/* Use Category Model */
		$categoryModel = $this->model('Category');
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();

		$data['categories'] = $categoryModel->list();	
            
        $data['users'] = $adminModel->select_all_users();
        
		$adminModel->update_sms_visible();

        $data['sms_logs'] = $adminModel->select_sms_logs();

        redirect('cps/sms');
    }
    
    /**
     * Candidates
     */
    public function usermanagement()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
		
		/* Use Admin Library */
        $admin = $this->library('Admin');
		$data['admin'] = $admin->data();
		if(!$admin->isLoggedIn()):
		 redirect('cps/login');
		endif;
		
		/* Use Candidate Model */
		$adminModel = $this->model('Admin');
		/* Use Category Model */
		$categoryModel = $this->model('Category');
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
		
		/* Use Input Library */
		$input = $this->library('Input');
        
        // Edit Page
        if(isset($this->url[2]) && $this->url[2] == 'add') {
            
           $data['categories'] = $categoryModel->list();	
            
                //Add Candidate Data
                if(isset($_POST['register_admin'])){
                 if ($input->exists()) {

                    $validator = $this->library('Validator');

                    $validation = $validator->check($_POST, [
                          'name' => [
                             'required' => true,
                          ],
                          'email' => [
                             'required' => true,
                             'email' => true,
                          ],
            			   'password' => [
            				 'required' => true,
            				 'minlength' => 6
            			   ],
            			   'confirmPassword' => [
            				 'required' => true,
            				 'match' => 'password'
            			   ]
                    ]);

                    if (!$validation->fails()) {

                        /* HasH Password */
                        $password = password_hash(PASSWORD, PASSWORD_DEFAULT);

                        /* Unique ID */	
                        $userid = $this->uniqueid();

                        $insert = $adminModel->insert_admin($input->get('name'), $input->get('email'), $input->get('mobile'), $password,$userid);
                        
                        if ($insert == 1) {
                            $_SESSION['message'][] = ['success', $this->lang['details_saved']];
                            redirect('cps/candidate/add');
                        } else {
                            $_SESSION['message'][] = ['warning', $this->lang['error_when_saving']];
                            redirect('cps/candidate/add');
                        }
                        
                     } else {

                         foreach ($validation->errors()->all() as $err) {
                            $str = implode(" ",$err);
                             foreach ($err as $r) {
                                $_SESSION['errors'][] = ['error', $r];
                             }	
                         }

                                    redirect('cps/usermanagement/add');
                   }

                 }
                }
				
                return ['content' => $this->view->render($data, 'admin/user_add')];
                
        }elseif(isset($this->url[2]) && $this->url[2] == 'list'){
            
                $data['admins'] = $adminModel->select_admins();	
				
                return ['content' => $this->view->render($data, 'admin/user_list')];
            
        }elseif(isset($this->url[2]) && $this->url[2] == 'edit') {			
			
            $has = $adminModel->has_admin($this->url[3]);
            
            /* URL */
            $data['m'] = $this->url[4];
		
            // If the currency requested exists
            if($has === true) {
				
                $data["admin"] = $adminModel->get_admin($this->url[3]);
			
				//Add Currency Data
				if(isset($_POST['edit_details'])){
				 if ($input->exists()) {

					$validator = $this->library('Validator');
					
					$validation = $validator->check($_POST, [
                          'name' => [
                             'required' => true,
                          ],
                          'email' => [
                             'required' => true,
                             'email' => true,
                          ],	
        				  'mobile' => [
        					 'required' => true,
        					 'minlength' => 8,
        					 'maxlength' => 8,
        				  ]
					]);
						 
					if (!$validation->fails()) {
						
						$update = $adminModel->update_admin($input->get('name'), $input->get('email'), $input->get('mobile'), $input->get('id'));
							
						if ($update == 1) {
							$_SESSION['message'][] = ['success', $this->lang['details_updated']];
							redirect('cps/usermanagement/edit/'. $input->get('id')) . '/details';
						} else {
							$_SESSION['message'][] = ['warning', $this->lang['no_changes_made']];
							redirect('cps/usermanagement/edit/'. $input->get('id')) . '/details';
						}
							
					 } else {

						 foreach ($validation->errors()->all() as $err) {
							$str = implode(" ",$err);
							 foreach ($err as $r) {
								$_SESSION['errors'][] = ['error', $r];
							 }	
						 }
                        
							redirect('cps/usermanagement/edit/'. $input->get('id')) . '/details';
				   }

				}
                
                } 
				
                return ['content' => $this->view->render($data, 'admin/user_edit')];
				
            } else {
                redirect('cps/usermanagement/list');
            }
        }       
    }
	
}