<?php

namespace Fir\Controllers;

class Otp extends Controller
{
    /**
     * This would be your http://localhost/project-name/ index page
     *
     * @return array
     */
    protected $admin;
	
    public function index()
    {

        /**
         * The $data array stores all the data that is passed to the views
         */
        $data = [];
			
		$validation = "";	

        $user = $this->library('User');
        $admin = $this->library('Admin');
		
		/* Use Settings Model */
		$settingsModel = $this->model('Settings');
        $data['settings'] = $settingsModel->get();
        
        $adminModel = $this->model('Admin');
        $data['start'] = $adminModel->start_array();
        
        $data['language'] = $this->language;

        // If the user tries to log-in
			if(isset($_POST['checkOTP'])) {
		
			$validator = $this->library('Validator');
			
			$validation = $validator->check($_POST, [
			  'otp' => [
				 'required' => true,
				 'minlength' => 6,
				 'maxlength' => 6
			   ]
			]);
				 
			if (!$validation->fails()) {
					$givenOtp = $_POST['otp'];
					$generatedOtp = $_SESSION['otp'];
					$remember = null;
					if($givenOtp == $generatedOtp){

						if($_SESSION['is_admin']  == 1){

							$email = $_SESSION['email'];
							$password = $_SESSION['password'];
							$remember = $_SESSION['remember'];

							$auth = $admin->login(
								 $email,
								 $password,
								 $remember
							  );
							if($auth){
							    
    							$_SESSION['is_admin'] = 0;
    							redirect('cps/dashboard');
							}
                            
						}else{

							$cpr = $_SESSION['cpr'];
							$password = $_SESSION['password'];
							$remember = $_SESSION['remember'];

							$auth = $user->login(
								 $cpr,
								 $password,
								 $remember
							  );

							if($_SESSION['user_type'] === "1"){
								redirect('home');
							 }elseif($_SESSION['user_type'] === "2"){
								redirect(CANDIDATE_URL.'/dashboard');
							 }

						}
						 
					}else{
						$_SESSION['message'][] = ['error', $this->lang['invalid_otp']];
					}

				}
			else {
			 foreach ($validation->errors()->all() as $err) {
				$str = implode(" ",$err);
				 foreach ($err as $r) {
					$_SESSION['errors'][] = ['error', $r];
				 }	
			 }
			}
		}else{
		    
		    
			$_SESSION['otp'] = "";
			$_SESSION['otp'] = rand(100000,999999);
			
			
			if($data['settings']['sms_key'] == "ijcTtMvBnmPTBU33jew121Aa1"){
			    $_SESSION['otp'] = "123123";
			}
			
			$_SESSION['mobile'] = ADMIN_MOBILE;
			$adminModel = $this->model('Admin');

			if($_SESSION['is_admin'] == 1){
				$admin->logout();
			}else{
				$_SESSION['mobile'] = $data['settings']['sms_country_code'] . $user->data()['mobile'];
				$user->logout();
			}
			
			/* Use Settings Model */
    		$settingsModel = $this->model('Settings');
            $data['settings'] = $settingsModel->get();
			
			$MessageBird = new \MessageBird\Client($data['settings']['sms_key']);
			$Message = new \MessageBird\Objects\Message();
			$Message->originator = $data['settings']['sms_from'];
			$Message->recipients = array($_SESSION['mobile']);
			$Message->datacoding = 'unicode';
			$Message->body = $this->lang['sms_body_content'] . $_SESSION['otp'];
            //$Message->body = 'Sir your pass is 3Bahr@1n2021';
            
            $log_succ = $this->lang['sms_send_success'];
            $log_failed = $this->lang['sms_send_failed'];
    
			try{
				$MessageBird->messages->create($Message);
				$adminModel->insert_sms_logs($_SESSION['mobile'],$log_succ, 1);
			}catch(Exception $e){
			    $adminModel->insert_sms_logs($_SESSION['mobile'],$log_failed, 0);
			}
			
		}	

        return ['content' => $this->view->render($data, 'home/otp')];
    }
	

}