<?php
defined('FIR') OR exit();
/**
 * The main template file
 * This file puts together the three main section of the software, header, content and footer
 */
?>

<!DOCTYPE html>
<?php if($data['lang'] == "english"){ ?>
    <html>
<?php }else{ ?>
    <html dir="rtl">
<?php } ?>
	<head>
	    <!-- ==============================================
		Title and Meta Tags
		=============================================== -->
		<meta charset="utf-8">
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
        <title><?=e($this->siteSettings('sitename'))?> - <?=e($this->siteSettings('title'))?></title>
		<meta name="description" content="<?=e($this->siteSettings('description'))?>">
		<meta name="keywords" content="<?=e($this->siteSettings('keywords'))?>">
		
		<link href="<?=$this->siteUrl().'/'.PUBLIC_PATH.'/'.UPLOADS_PATH?>/admin/<?=e($this->siteSettings('favicon'))?>" rel="icon">
		
		<link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/css/bootstrap.css">
        <!-- end Google Font -->
        <!-- owl carousel SLIDER -->
        <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/css/owl.carousel.css">
        <!-- end awesome icons -->
        <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/css/font-awesome.css">
        <!-- lightbox -->
        <link href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/css/prettyPhoto.css" rel="stylesheet">
        
        <!-- Animation Effect CSS -->
        <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/css/animation.css">
        <!-- Main Stylesheet CSS -->
        <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/style.css">
        
        
        <?php if($data['lang'] == "english"){ ?>
            <link rel="stylesheet" type="text/css" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/css/rtl_base_en.css">
            <link rel="stylesheet" type="text/css" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/css/rtl_style_en.css">
        <?php }else{ ?>
            <link rel="stylesheet" type="text/css" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/css/rtl_base.css">
            <link rel="stylesheet" type="text/css" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/css/rtl_style.css">
        <?php } ?>
        <link rel="stylesheet" href="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote.min.css">
        
        <script src="https://kit.fontawesome.com/07d64808c6.js" crossorigin="anonymous"></script>
        
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/jquery.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/bootstrap.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/smooth-scroll.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/jquery.parallax-1.1.3.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/jquery.easypiechart.min.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/owl.carousel.js"></script>
    	<script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/jquery.jigowatt.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/custom.js"></script>
    	<script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/jquery.unveilEffects.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/home/js/jquery.isotope.min.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/js/front.js"></script>
        <script src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/sweetalert/sweetalert.min.js"></script>
        
        <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote.min.js"></script>
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote-ext-rtl.js"></script>
            <script>
                $(document).ready(function() {
                  $('#summernote,#summernote-1,#summernote-2,#summernote-3,#summernote-4').summernote({
                    height: 200,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'italic', 'underline', 'clear']], 
                        ['para', ['ul', 'ol', 'paragraph']],
                      ],				 
                  });
                });
            </script>
         
         
			<?=$data['scripts_view']?>
        
        <style>
            @font-face {
              font-family: SST-Arabic-Roman;
              src: url('<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/SST-Arabic-Roman/SST-Arabic-Roman.ttf'); 
            }
            
            @font-face {
              font-family: SST-Arabic-Light;
              src: url('<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/SST-Arabic-Light/SST-Arabic-Light.ttf'); 
            }
        </style>
        
		
		<!-- Global site tag (gtag.js) - Google Analytics -->
		<script async src="https://www.googletagmanager.com/gtag/js?id=<?=e($this->siteSettings('analytics'))?>"></script>
		<script>
		  window.dataLayer = window.dataLayer || [];
		  function gtag(){dataLayer.push(arguments);}
		  gtag('js', new Date());

		  gtag('config', '<?=e($this->siteSettings('analytics'))?>');
		</script>	
  </head>
  
<body>
     
     <!-- ==============================================
     Wrapper Section
     =============================================== -->
	 <div class="main">
         
			<?php if($data['url'] == 'login' || $data['url'] == 'register' || $data['url'] == 'forgot' || $data['url'] == 'reset' || $data['url'] == 'otp' || $data['url'] == ''): ?>
              <?=$data['content_view']?>
            <?php else: ?> 
		      <?=$data['header_view']?>
	 	      <?=$data['content_view']?>
		      <?=$data['footer_view']?>
			<?php endif; ?>
        
        
	 
		<!-- ==============================================
		Scripts
		=============================================== --> 
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/Admin/plugins/datatables/datatables.min.js"></script>
          <script>
          $(document).ready( function () {
            $('#myTable').DataTable({
                  "ordering": false,    
            });
          } );  

          </script>         
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote.min.js"></script>
          <script type="text/javascript" src="<?=$this->siteUrl()?>/<?=$this->themePath()?>/<?=$this->theme()?>/assets/vendor/summernote/summernote-ext-rtl.js"></script>
            <script>
                $(document).ready(function() {
                  $('#summernote,#summernote-1,#summernote-2,#summernote-3,#summernote-4').summernote({
                    height: 200,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'italic', 'underline', 'clear']], 
                        ['para', ['ul', 'ol', 'paragraph']],
                      ],				 
                  });
                });
            </script>
         
         
			<?=$data['scripts_view']?>
	 	
     </div><!-- /.wrapper -->  
</body>
</html>